<?php
require_once '../config/db.php';

$supplier_id = isset($_GET['supplier_id']) ? intval($_GET['supplier_id']) : 0;
$start_date = isset($_GET['start_date']) ? $_GET['start_date'] : '';
$end_date = isset($_GET['end_date']) ? $_GET['end_date'] : '';
$print = isset($_GET['print']) && $_GET['print'] == 1;

if (!$supplier_id) {
    if ($print) {
        echo '<p class="text-danger">Invalid supplier</p>';
    } else {
        echo '<tr><td colspan="5" class="text-danger">Invalid supplier</td></tr>';
    }
    exit;
}

// Fetch supplier info for print view
if ($print) {
    $stmt = $pdo->prepare("SELECT * FROM suppliers WHERE id = ?");
    $stmt->execute([$supplier_id]);
    $supplier = $stmt->fetch();
}

$where = ['supplier_id = ?'];
$params = [$supplier_id];
if ($start_date) {
    $where[] = 'DATE(created_at) >= ?';
    $params[] = $start_date;
}
if ($end_date) {
    $where[] = 'DATE(created_at) <= ?';
    $params[] = $end_date;
}
$where_sql = $where ? 'WHERE ' . implode(' AND ', $where) : '';

$sql = "SELECT * FROM supplier_payments $where_sql ORDER BY created_at DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$payments = $stmt->fetchAll();

if ($print) {
    echo '<html><head><title>Supplier Payment History</title>';
    echo '<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">';
    echo '<style> 
        .centered-line { margin: 20px auto; border: 0; border-top: 2px solid #333; width: 60%; } 
        .ph-supplier-info { text-align: center; margin-bottom: 20px; }
        .ph-table th, .ph-table td { font-size: 0.95em; padding: 6px 8px; }
        .ph-table { width: 100%; max-width: 100%; margin: 0 auto; }
        @media print { .ph-table { font-size: 11px; } }
    </style>';
    echo '</head><body>';
    echo '<div class="ph-supplier-info">';
    echo '<h3>Supplier Information</h3>';
    echo '<strong>Name:</strong> ' . htmlspecialchars($supplier['name']) . '<br>';
    echo '<strong>Contact:</strong> ' . htmlspecialchars($supplier['contact_person']) . ' | ' . htmlspecialchars($supplier['phone']) . '<br>';
    echo '<strong>Email:</strong> ' . htmlspecialchars($supplier['email']) . '<br>';
    echo '<strong>Address:</strong> ' . htmlspecialchars($supplier['address']) . '<br>';
    echo '</div>';
    echo '<hr>';
    echo '<h4 class="text-center">Supplier Payment History</h4>';
    echo '<hr class="centered-line">';
    echo '<table class="table table-bordered ph-table"><thead><tr>';
    echo '<th>Date</th><th>Product</th><th>Serial Numbers</th><th>Qty</th><th>Payment Amount</th><th>Payment Method</th><th>Reference</th><th>Balance After</th>';
    echo '</tr></thead><tbody>';
    if (!$payments) {
        echo '<tr><td colspan="8" class="text-center">No payment history found</td></tr>';
    } else {
        foreach ($payments as $pay) {
            // Fetch items for this payment (from supplier_receipts)
            $stmtItems = $pdo->prepare("SELECT sr.*, p.name as product_name FROM supplier_receipts sr JOIN products p ON sr.product_id = p.id WHERE sr.supplier_id = ? AND sr.payment_status = 'paid' AND sr.updated_at = ?");
            $stmtItems->execute([$supplier_id, $pay['created_at']]);
            $items = $stmtItems->fetchAll();
            if ($items) {
                foreach ($items as $item) {
                    // Fetch serial numbers for this receipt and product
                    $stmtSerials = $pdo->prepare("SELECT serial_number FROM product_serial_numbers WHERE product_id = ? AND source_type = 'supplier_receipt' AND source_id = ?");
                    $stmtSerials->execute([$item['product_id'], $item['id']]);
                    $serials = $stmtSerials->fetchAll(PDO::FETCH_COLUMN);
                    $serials_str = $serials ? htmlspecialchars(implode(', ', $serials)) : '-';

                    echo '<tr>';
                    echo '<td>' . htmlspecialchars(date('Y-m-d H:i', strtotime($pay['created_at']))) . '</td>';
                    echo '<td>' . htmlspecialchars($item['product_name']) . '</td>';
                    echo '<td>' . $serials_str . '</td>';
                    echo '<td>' . number_format($item['quantity'], 2) . '</td>';
                    echo '<td>' . number_format($pay['amount'], 2) . '</td>';
                    echo '<td>' . htmlspecialchars(ucfirst($pay['payment_method'])) . '</td>';
                    echo '<td>' . htmlspecialchars($pay['reference']) . '</td>';
                    echo '<td>' . number_format($pay['balance_after'], 2) . '</td>';
                    echo '</tr>';
                }
            } else {
                // No items for this payment
                echo '<tr>';
                echo '<td>' . htmlspecialchars(date('Y-m-d H:i', strtotime($pay['created_at']))) . '</td>';
                echo '<td>-</td><td>-</td><td>-</td>';
                echo '<td>' . number_format($pay['amount'], 2) . '</td>';
                echo '<td>' . htmlspecialchars(ucfirst($pay['payment_method'])) . '</td>';
                echo '<td>' . htmlspecialchars($pay['reference']) . '</td>';
                echo '<td>' . number_format($pay['balance_after'], 2) . '</td>';
                echo '</tr>';
            }
        }
    }
    echo '</tbody></table>';
    echo '<script>window.onload = function() { window.print(); }</script>';
    echo '</body></html>';
    exit;
}

if (!$payments) {
    echo '<tr><td colspan="5" class="text-center">No payment history found</td></tr>';
    exit;
}

foreach ($payments as $pay) {
    // Fetch items for this payment (from supplier_receipts)
    $stmtItems = $pdo->prepare("SELECT sr.*, p.name as product_name FROM supplier_receipts sr JOIN products p ON sr.product_id = p.id WHERE sr.supplier_id = ? AND sr.payment_status = 'paid' AND sr.updated_at = ?");
    $stmtItems->execute([$supplier_id, $pay['created_at']]);
    $items = $stmtItems->fetchAll();
    if ($items) {
        foreach ($items as $item) {
            // Fetch serial numbers for this receipt and product
            $stmtSerials = $pdo->prepare("SELECT serial_number FROM product_serial_numbers WHERE product_id = ? AND source_type = 'supplier_receipt' AND source_id = ?");
            $stmtSerials->execute([$item['product_id'], $item['id']]);
            $serials = $stmtSerials->fetchAll(PDO::FETCH_COLUMN);
            $serials_str = $serials ? htmlspecialchars(implode(', ', $serials)) : '-';

            echo '<tr>';
            echo '<td>' . htmlspecialchars(date('Y-m-d H:i', strtotime($pay['created_at']))) . '</td>';
            echo '<td>' . htmlspecialchars($item['product_name']) . '</td>';
            echo '<td>' . $serials_str . '</td>';
            echo '<td>' . number_format($item['quantity'], 2) . '</td>';
            echo '<td>' . number_format($pay['amount'], 2) . '</td>';
            echo '<td>' . htmlspecialchars(ucfirst($pay['payment_method'])) . '</td>';
            echo '<td>' . htmlspecialchars($pay['reference']) . '</td>';
            echo '<td>' . number_format($pay['balance_after'], 2) . '</td>';
            echo '</tr>';
        }
    } else {
        // No items for this payment
        echo '<tr>';
        echo '<td>' . htmlspecialchars(date('Y-m-d H:i', strtotime($pay['created_at']))) . '</td>';
        echo '<td>-</td><td>-</td><td>-</td>';
        echo '<td>' . number_format($pay['amount'], 2) . '</td>';
        echo '<td>' . htmlspecialchars(ucfirst($pay['payment_method'])) . '</td>';
        echo '<td>' . htmlspecialchars($pay['reference']) . '</td>';
        echo '<td>' . number_format($pay['balance_after'], 2) . '</td>';
        echo '</tr>';
    }
} 